//
//  YHNoNeedAppointMembersCell.swift
//  galaxy
//
//  Created by edy on 2024/8/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHNoNeedAppointMembersCell: UITableViewCell {

    static let cellReuseIdentifier = "YHNoNeedAppointMembersCell"

    var members: [YHHKMemberModel] = [] {
        didSet {
            var text = ""
            for (index, user) in members.enumerated() {
                text += "\(user.name) (\(user.getAgeAndMonth()))"
                if index != members.count-1 {
                    text += "、"
                }
            }
            detailLabel.text = text
        }
    }
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.textColor = .mainTextColor
        label.font = UIFont.PFSC_M(ofSize: 14)
        label.text = "无需预约办证成员（未满11岁）"
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.textColor = .mainTextColor(alpha: 0.7)
        label.font = UIFont.PFSC_R(ofSize: 14)
        return label
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(detailLabel)
        
        whiteContentView.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(0)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(18)
            make.right.equalTo(-18)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(8)
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.bottom.equalTo(-16)
        }
    }

}
